﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


namespace BMS.Utils
{
    /// <summary>
    /// EIS access constants class.
    /// </summary>
    public class EISConstants
    {
        #region Entity Type Identifier

        /// <summary>
        /// Entity type identifier for organization.
        /// </summary>
        public const string ORGANIZATON = "HL7-RIM-V3-Organization";

        /// <summary>
        /// Entity type identifier for place.
        /// </summary>
        public const string PLACE = "HL7-RIM-V3-Place";

        /// <summary>
        /// Entity type identifier for person.
        /// </summary>
        public const string PERSON = "HL7-RIM-V3-Person";

        #endregion

        #region Domain Identifier

        /// <summary>
        /// Domain identifier for medica soft
        /// </summary>
        //public const string MEDICASOFTDOMAIN = "InfoWorld";

        #endregion

        #region Trait Identifier

        /// <summary>
        /// Identifier for R_ServiceDeliveryLocation class.
        /// </summary>
        public const string SDLOC = "SDLOC";

        /// <summary>
        /// Identifier for R_Member class.
        /// </summary>
        public const string MBR = "MBR";

        /// <summary>
        /// Identifier for R_MaintainedEntity class.
        /// </summary>
        public const string MNT = "MNT";

        /// <summary>
        /// Identifier for R_LocatedEntity class.
        /// </summary>
        public const string LOCE = "LOCE";

        /// <summary>
        /// Identifier for R_OwnedEntity class.
        /// </summary>
        public const string OWN = "OWN";

        /// <summary>
        /// Identifier for R_Patient class.
        /// </summary>
        public const string PAT = "PAT";

        /// <summary>
        /// Identifier for R_HealthcareProvider class.
        /// </summary>
        public const string PROV = "PROV";

        /// <summary>
        /// Trait identifier for Name.
        /// </summary>
        public const string NAME = "NAME";

        /// <summary>
        /// Trait identifier for Description.
        /// </summary>
        public const string DESCRIPTION = "DESCRIPTION";

        /// <summary>
        /// Trait identifier for Unique Identification.
        /// </summary>
        public const string UID = "UID";

        /// <summary>
        /// Trait identifier for Root.
        /// </summary>
        public const string CODE = "CODE";

        /// <summary>
        /// Trait identifier for IEN.
        /// </summary>
        public const string IEN = "IEN";

        /// <summary>
        /// Trait identifier for SSN.
        /// </summary>
        public const string SSN = "SSN";

        /// <summary>
        /// Trait identifier for SITE.
        /// </summary>
        public const string SITE = "SITE";

        /// <summary>
        /// Trait identifier for NUMBER.
        /// </summary>
        public const string NUMBER = "NUMBER";


        /// <summary>
        /// Trait identifier for Type Group (Specialty).
        /// </summary>
        public const string TYPEGROUP = "TYPE_GROUP";

        /// <summary>
        /// Trait identifier for Vista Specility.
        /// </summary>
        public const string VISTASPECIALTY = "VISTA_SPECIALITY";

        /// <summary>
        /// Trait identifier for Phone.
        /// </summary>
        public const string PHONE = "CONTACT1";

        /// <summary>
        /// trait identifier for contact.
        /// </summary>
        public const string PERSON_CONTACT_NAME = "POINT_OF_CONTACT";

        public const string PERSON_WEIGHT = "PERSON_WEIGHT";

        public const string IS_PATIENT_OPTOUT = "IS_PATIENT_OPTOUT";

        /// <summary>
        /// trait identifier for ward location.
        /// </summary>
        public const string WARD_LOCATION_ID = "WARD_LOCATION_ID";

        /// <summary>
        /// trait identifier for email.
        /// </summary>
        public const string EMAIL = "CONTACT2";

        /// <summary>
        /// contact type value for email.
        /// </summary>
        public const string EMAIL_CONTACT_VALUE = "mailto:";

        /// <summary>
        /// contact type value for telephone.
        /// </summary>
        public const string TELEPHONE_CONTACT_VALUE = "tel:";

        /// <summary>
        /// contact type value for fax.
        /// </summary>
        public const string FAX_CONTACT_VALUE = "fax:";

        /// <summary>
        /// trait identifier for contact4.
        /// </summary>
        public const string TELEPHONE = "CONTACT3";

        /// <summary>
        /// TYPE_CODE(code) for facility.
        /// </summary>
        public const string FACILITY_CODE = "FACILITY";

        /// <summary>
        /// TYPE_NAME (display name) for facility.
        /// </summary>
        public const string FACILITY_NAME = "Facility";

        /// <summary>
        /// TYPE_CODE(code) for VISN
        /// </summary>
        public const string VISN_CODE = "VISN";

        /// <summary>
        /// TYPE_NAME (display name) for VISN.
        /// </summary>
        public const string VISN_NAME = "VISN";

        /// <summary>
        /// TYPE_CODE (code) for ward group.
        /// </summary>
        public const string WARD_GROUP_CODE = "WARD_GROUP";

        /// <summary>
        /// TYPE_NAME (display name) for Ward Group.
        /// </summary>
        public const string WARD_GROUP_NAME = "Ward Group";

        /// <summary>
        /// TYPE_CODE (code) for vista site.
        /// </summary>
        public const string VISTA_SITE_CODE = "VISTA_SITE";

        /// <summary>
        /// TYPE_NAME (display name) for vista site.
        /// </summary>
        public const string VISTA_SITE_NAME = "Vista Site";

        /// <summary>
        /// TYPE_CODE (code) for hospital location.
        /// </summary>
        public const string HOSPITAL_LOCATION_CODE = "HOSPITAL_LOCATION";

        /// <summary>
        /// TYPE_NAME (display name) for hospital location.
        /// </summary>
        public const string HOSPITAL_LOCATION_NAME = "Hospital Location";

        /// <summary>
        /// TYPE_CODE (code) for ward.
        /// </summary>
        public const string WARD_CODE = "WARD";

        /// <summary>
        /// TYPE_NAME (display name) for ward.
        /// </summary>
        public const string WARD_NAME = "Ward";

        /// <summary>
        /// Code system for role.
        /// </summary>
        public const string ROLE_CODE_SYSTEM = "2.16.840.1.113883.5.111";

        /// <summary>
        /// Code system name for role.
        /// </summary>
        public const string ROLE_CODE = "RoleCode";

        /// <summary>
        /// Code system for organization.
        /// </summary>
        public const string ORGANIZATION_CHART_CODE_SYSTEM = "2.12.24.40";

        /// <summary>
        /// Code system name for organization.
        /// </summary>
        public const string ORGANIZATION_CHART_CODE = "OrganizationChart";

        /// <summary>
        /// Trait identifier for IS_ACTIVE.
        /// </summary>
        public const string IS_ACTIVE = "IS_ACTIVE";

        /// <summary>
        /// Trait identifier for IS_ALIVE.
        /// </summary>
        public const string IS_ALIVE = "IS_ALIVE";

        /// <summary>
        /// Trait identifier for SITE_NUMBER
        /// </summary>
        public const string SITE_NUMBER = "SITE_NUMBER";

        /// <summary>
        /// Trait identifier for WHITEBOARD_REPORT_PATH
        /// </summary>
        public const string WHITEBOARD_REPORT_PATH = "WHITEBOARD_REPORT_PATH";

        /// <summary>
        /// Trait identifier for the place's address.
        /// </summary>
        public const string ADDRESS1 = "PUBLIC_ADDRESS";

        /// <summary>
        /// Trait identifier for second address of place.
        /// </summary>
        public const string ADDRESS2 = "WORK_PLACE_ADDRESS";

        /// <summary>
        /// Trait value for IS_ACTIVE.
        /// </summary>
        public const string TRUE = "TRUE";

        /// <summary>
        /// Trait value for IS_ACTIVE.
        /// </summary>
        public const string FALSE = "FALSE";

        /// <summary>
        /// Trait identifier for last name.
        /// </summary>
        public const string NAME_FAMILY = "NAME_FAMILY";

        /// <summary>
        /// Trait identifier for first given name.
        /// </summary>
        public const string NAME_FIRST_GIVEN = "NAME_FIRST_GIVEN";

        /// <summary>
        /// Trait identifier for middle name.
        /// </summary>
        public const string NAME_SECOND_GIVEN = "NAME_SECOND_GIVEN";

        /// <summary>
        /// Trait identifier for person gender.
        /// </summary>
        public const string GENDER = "ADMINISTRATIVE_GENDER";

        /// <summary>
        /// Trait identifier for date of birth of the person.
        /// </summary>
        public const string DATE_OF_BIRTH = "BIRTH_TIME";

        /// <summary>
        /// Trait identifier for vista validated.
        /// </summary>
        public const string IS_VISTA_VALIDATED = "IS_VISTA_VALIDATED";

        /// <summary>
        /// Trait identifier for currently oos.
        /// </summary>
        public const string IS_CURRENTLY_OOS = "IS_CURRENTLY_OOS";

        /// <summary>
        /// Trait to determine whether or not a ward specialty will show up on whiteboard in kiosk mode
        /// </summary>
        public const string HIDE_SPECIALTY_KIOSK = "HIDE_SPECIALTY_WHITEBOARD";

        /// <summary>
        /// Trait to determine whether or not a ward specialty will show up on whiteboard in desktop mode
        /// </summary>
        public const string HIDE_SPECIALTY_DESKTOP = "HIDE_SPECIALTY_DESKTOP";

        /// <summary>
        /// Trait identifier for whether or not a ward exists in BMS only (non-VistA).
        /// </summary>
        public const string IS_VIRTUAL_WARD = "IS_VIRTUAL_WARD";

        /// <summary>
        /// Trait for wards to determine which census category to group them in.
        /// </summary>
        public const string CENSUS_CATEGORY = "CENSUS_CATEGORY";

        /// <summary>
        /// Trait for wards to show which virtual ward they are assigned to.
        /// </summary>
        public const string ASSIGNED_VIRTUAL_WARD = "ASSIGNED_VIRTUAL_WARD";

        /// <summary>
        /// Trait identifier for admitting diagnosis.
        /// </summary>
        public const string ADMITTING_DIAGNOSIS = "ADMITTING_DIAGNOSIS";

        /// <summary>
        /// Trait identifier for attending physician.
        /// </summary>
        public const string ATTENDING_PHYSICIAN = "ATTENDING_PHYSICIAN";

        /// <summary>
        /// Trait identifier for the patient iens (list of patients iens)
        /// </summary>
        public const string IEN_LIST = "IEN_LIST";

        /// <summary>
        /// Trait identifier for patient treating specialty.
        /// </summary>
        public const string TREATING_SPECIALTY = "TREATING_SPECIALTY";

        /// <summary>
        /// Trait identifier for patient service connected percentage.
        /// </summary>
        public const string SERVICE_CONNECTED_PERCENTAGE = "SERVICE_CONNECTED_PERCENTAGE";

        /// <summary>
        /// Trait identifier for NurseAssignment property of the bed.
        /// </summary>
        public const string NURSE_ASSIGNMENT = "NURSE_ASSIGNMENT";

        /// <summary>
        /// Trait identifier for Comment property of the bed.
        /// </summary>
        public const string COMMENT = "COMMENT";

        /// <summary>
        /// Trait identifier for Reason property of the bed.
        /// </summary>
        public const string REASON = "REASON";

        /// <summary>
        /// Trait identifier for BedStatus property of the bed.
        /// </summary>
        public const string BED_STATUS = "BED_STATUS";

        /// <summary>
        /// Trait identifier for IsBedHold property of the bed.
        /// </summary>
        public const string IS_BED_HOLD = "IS_BED_HOLD";

        /// <summary>
        /// Trait identifier for region.
        /// </summary>
        public const string IDENTIFIER_FOR_REGION_CODE = "REG";

        /// <summary>
        /// Trait identifier for visn.
        /// </summary>
        public const string IDENTIFIER_FOR_VISN_CODE = "VISN";

        /// <summary>
        /// Trait identifier for vista site.
        /// </summary>
        public const string IDENTIFIER_FOR_VISTA_SITE_CODE = "VST";

        /// <summary>
        /// Trait identifier for hospital location.
        /// </summary>
        public const string IDENTIFIER_FOR_HOSPITAL_LOCATION_CODE = "HLOC";

        /// <summary>
        /// Trait identifier for facility.
        /// </summary>
        public const string IDENTIFIER_FOR_FACILITY_CODE = "FAC";

        /// <summary>
        /// Trait identifier for wardgroup.
        /// </summary>
        public const string IDENTIFIER_FOR_WARDGROUP_CODE = "WGR";

        /// <summary>
        /// Trait identifier for ward.
        /// </summary>
        public const string IDENTIFIER_FOR_WARD_CODE = "WRD";

        /// <summary>
        /// Trait identifier for bed.
        /// </summary>
        public const string IDENTIFIER_FOR_BED_CODE = "BED";

        /// <summary>
        /// Trait identifier for region (description).
        /// </summary>
        public const string IDENTIFIER_FOR_REGION_NAME = "REGION";

        /// <summary>
        /// Trait identifier for visn (description).
        /// </summary>
        public const string IDENTIFIER_FOR_VISN_NAME = "VISN";

        /// <summary>
        /// Trait identifier for vista site (description).
        /// </summary>
        public const string IDENTIFIER_FOR_VISTA_SITE_NAME = "VISTA SITE";

        /// <summary>
        /// Trait identifier for hospital location (description).
        /// </summary>
        public const string IDENTIFIER_FOR_HOSPITAL_LOCATION_NAME = "HOSPITAL LOCATION";

        /// <summary>
        /// Trait identifier for facility (description).
        /// </summary>
        public const string IDENTIFIER_FOR_FACILITY_NAME = "FACILITY";

        /// <summary>
        /// Trait identifier for wardgroup (description).
        /// </summary>
        public const string IDENTIFIER_FOR_WARDGROUP_NAME = "WARD GROUP";

        /// <summary>
        /// Trait identifier for ward (description).
        /// </summary>
        public const string IDENTIFIER_FOR_WARD_NAME = "WARD";

        /// <summary>
        /// Trait identifier for bed (description).
        /// </summary>
        public const string IDENTIFIER_FOR_BED_NAME = "BED";

        #endregion

        public static readonly string EIS_ORGANIZATION_TYPE = "HL7-RIM-V3-Organization";
        public static readonly string EIS_PERSON_TYPE = "HL7-RIM-V3-Person";
        public static readonly string EIS_DEVICE_TYPE = "HL7-RIM-V3-Device";
        public static readonly string EIS_PLACE_TYPE = "HL7-RIM-V3-Place";
        public static readonly string EIS_MATERIAL_TYPE = "HL7-RIM-V3-Material";

        public static readonly List<string> EIS_DOMAIN_ID_LIST = null;
        public static readonly List<string> EIS_ORGANIZATION_TYPE_LIST = new List<string>(
            new string[] { EIS_ORGANIZATION_TYPE });
        public static readonly List<string> EIS_DEVICE_TYPE_LIST = new List<string>(
            new string[] { EIS_DEVICE_TYPE });
        public static readonly List<string> EIS_PLACE_TYPE_LIST = new List<string>(
            new string[] { EIS_PLACE_TYPE });
        public static readonly List<string> EIS_PERSON_TYPE_LIST = new List<string>(
            new string[] { EIS_PERSON_TYPE });

        public static readonly string VIRTUAL_DIVISION_NAME = "Vista Virtual Division";
        public static readonly string VIRTUAL_DIVISION_ID = "-1";

        public static readonly int GET_ENTITY_FILTR_MAX_ENTITIES = 200;
    }
}
